library IEEE; 
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;
use IEEE.math_real.all;  -- used for sin() and π
 
entity dp_ram_2048x16 is  
generic ( 
    addr_width : natural := 11;--2048x16  
    data_width : natural := 16); 
port ( 
    write_en : in std_logic; 
    waddr : in  std_logic_vector (addr_width - 1 downto 0);  
    wclk : in std_logic; 
    raddr : in  std_logic_vector (addr_width - 1 downto 0);  
    rclk : in std_logic; 
    din : in std_logic_vector (data_width - 1 downto 0);  
    dout : out std_logic_vector (data_width - 1 downto 0)); 
end dp_ram_2048x16; 
 
architecture rtl of dp_ram_2048x16 is 

    type mem_type is array ((2** addr_width) - 1 downto 0) of  
        std_logic_vector(data_width - 1 downto 0); 
		
	-- Function for sine wave generation (16-bit unsigned)
	function init_sine return mem_type is
		variable tmp   : mem_type;
		variable angle : real;
		variable sine_val : real;
		variable value : integer;
	begin
		for i in 0 to (2**addr_width - 1) loop
			angle := 2.0 * math_pi * real(i) / real(2**addr_width);
			sine_val := sin(angle);  -- -1..1
			-- map -1..1 to 0..65535
			value := integer(round((sine_val + 1.0) * 65535.0 / 2.0));
			tmp(i) := conv_std_logic_vector(value, data_width);
		end loop;
		return tmp;
	end function;

	
-- Fill the RAM with sine values
    signal mem : mem_type := init_sine;	
	
begin 
    process (wclk) 
    -- Write memory.  
    begin 
        if (wclk'event and wclk = '1') then  
            if (write_en = '1') then 
                mem(conv_integer(waddr)) <= din;
				-- Using write address bus.  
			end if; 
		end if;  
	end process; 
	process (rclk)
	-- Read memory.  
	begin 
		if (rclk'event and rclk = '1') then  
			dout <= mem(conv_integer(raddr));
			-- Using read address bus.  
		end if; 
	end process;  
end rtl; 